clc
clear
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default

%% Input data
%Physical parameters
Rg=287.053; %Costante dell'aria (J/kg/K)
mu=1.81e-5; %viscosita` dinamica dell'aria a 20C (Pa s)
pa=101325;
Temp=293;                  %Temperature (K)
rho=pa/(Rg*Temp);
dt=4e-9;                %Time Step (s)
cG=60000/rho;
%Geometrical parameters
R1 =15.5e-3 ; % inner radius (m)
R2 =31e-3 ;  % outer radius (m)
r_i = 15.5*1e-3;
r_e = 31*1e-3;
r_m = (r_i+r_e)/2;
T1d=0; %deg
T1=T1d*pi/180;
no_grooves=12;
passo = 2*pi*R2/no_grooves;
% T2 = 2*pi/no_grooves;     %= 2*pi/K [rad] periodicity angle
T2 = 2*pi;
Omega_rpm=5e3;
% Omega_rpm = omega;
omega=Omega_rpm*2*pi/60;
h_vec = (5:25)*1e-6;
h_mean = 22.6e-6;

%Definizione numero elementini nelle due direzioni
M=30; %direzione radiale
N=360*1.5;%direzione circonferenziale
deltar=(R2-R1)/(M-1);
deltat=(T2-T1)/(N-1);
nR =linspace(R1,R2,M)'; %Vettore dei raggi
nT =linspace(T1,T2,N)';%Vettore degli angoli

[Theta,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
Theta = Theta';R = R';
%caso di periodicit
% nT=[nT(end), nT, nT(1)];
% Convert grid to cartesian coordintes
ext_isGroove = importdata("isGroove.txt");
ext_isGroove = ext_isGroove ==1;
z_mat_flat = importdata("z_mat_flat.txt");
% z_groove = z_mat_flat(ext_isGroove);
r_mean_groove = zeros(1,size(ext_isGroove,2)-10);
cont = 0;
for j = 11:size(ext_isGroove,2)
    cont = cont + 1;
    r_mean_groove(cont) = mean(z_mat_flat(ext_isGroove(:,j),j))*1e-6;
end
r_vec = linspace(R1,R2,size(ext_isGroove,2));r_vec = r_vec(11:end);

[xData, yData] = prepareCurveData( r_vec, r_mean_groove );
% Set up fittype and options.
ft = fittype( 'poly7' );
% Fit model to data.
warning off
[coef, ~] = fit( xData, yData, ft);
warning on
groove_func = @(r) coef.p1*r.^7 + coef.p2*r.^6 + coef.p3*r.^5 + coef.p4*r.^4 + coef.p5*r.^3 + coef.p6*r.^2 ...
    + coef.p7*r + coef.p8;
groove_mean = 0.02575;
groove_sigma = 0.003247;

r_mean_plane = zeros(size(z_mat_flat,2),1);
for i = 1:length(r_mean_plane)
    r_mean_plane(i) = mean(z_mat_flat(~ext_isGroove(:,i),i))*1e-6;
end

r_vec = linspace(R1,R2,size(ext_isGroove,2));
[xData, yData] = prepareCurveData( r_vec, r_mean_plane' );
ft = fittype( 'poly9' );
warning off
[coef, gof] = fit( xData, yData, ft);
warning on
flat_func = @(r) coef.p1*r.^9 + coef.p2*r.^8 + coef.p3*r.^7 + coef.p4*r.^6 + coef.p5*r.^5 ...
    + coef.p6*r.^4 + coef.p7*r.^3 + coef.p8*r.^2 + coef.p9*r + coef.p10;

%% Geometry definition
beta = 70; beta = deg2rad(beta);
delta_beta = 0;
a1 = 11e-3 ;
a2 = 5.5e-3;              %a1=X*a2
Rb = 20e-3;
X_spiral = a1/a2;
Y_spiral = (R2-Rb)/(R2-R1);
% b = 3.5e-3 ;            %b=Y*(b+c)
% Rb = R2-b;
c = Rb-R1;
alfaSpiral = deg2rad(60);       % base angle of spiral [rad] (optm Muijdermann)
h1=32e-6;
h2=h_vec(1);
sh = h1-h2;

%Indentify grooved regions
angle = -tan(alfaSpiral)*log(R/R2);         % foundametal log spiral leading edge
[ang,ang1,isGroove] = GetGrooves(R1*1e3,R2*1e3,X_spiral,Y_spiral,no_grooves,beta,delta_beta,R*1e3,Theta);

Z = zeros(size(R));
Z(isGroove) = h_vec(1)+sh;
Z(~isGroove) = h_vec(1);

pad_section = 30; % [deg]
n_points = pad_section/360*N;
N = n_points;
H0 = Z(1:n_points,:);
H0 = [Z(end,:);H0;Z(n_points+1,:)]';
isGroove = H0==h_vec(1)+sh;
R = [R(end,:);R(1:n_points+1,:)]';
T = [Theta(end,:);Theta(1:n_points+1,:)]';
H0_aux_groove = -groove_func(R);
% H0(isGroove) = H0_aux_groove(isGroove)+h2;
H0(isGroove) = h_mean + h2;
H0_aux_flat = abs(flat_func(R));
% H0(~isGroove) = H0_aux_flat(~isGroove)+h2;
H0(~isGroove) = h2;
H0(end,end) = h2;
X = R.*cos(T);
Y = R.*sin(T);
% Rv=sqrt(X.^2+Y.^2);
Rv = R;

figure
mesh(X*1e3,Y*1e3,H0*1e6)
xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Air Gap Height ($\mu m$)')
% colorbar
% view(2)
% axis equal
pause(0.1)


%% Variable Initialization
%COndizioni Periodicit
% pold=ones(N+2,M)*pa; %N+2 per periodicit circolare lungo theta
% pnew=ones(N+2,M)*pa;
%COndizioni di Dirichelet p=Pa sul bordo esterno

Ft=[];
Gint=[];
Goutt=[];
Err_G=[];

Err_P=[];
Err_F=[];
no_punti=100;
no_pad=12;
W = zeros(size(h_vec));
Qin = W;
Qout = W;

for h_i = 1:length(h_vec)
    Pold=ones(M,N+2)*pa; %MODIFICATO
    Pnew=Pold;

    % H0(isGroove) = h_vec(h_i)+H0_aux_groove(isGroove);
    H0(isGroove) = h_vec(h_i)+h_mean;
    % H0(~isGroove) = h_vec(h_i)+H0_aux_flat(~isGroove);
    H0(~isGroove) = h_vec(h_i);
    H0(end,end) = h_vec(h_i);
    fprintf('h = %d um\n',h_vec(h_i)*1e6)


    tic
    err_P=10;
    err_F=10;
    err_G=10;

    %portate uscita nodo
    GN=zeros(M,N); %N and M are for BC
    GS=zeros(M,N);
    gO=zeros(M,N);
    gE=zeros(M,N);
    F0=0;
    F1=0;

    iter=0;
    contatore=0;
    toll=1e-6;
    while abs(err_P)>toll || abs(err_G)>toll || abs(err_F)>toll
        iter=iter+1;
        contatore=contatore+1;
        F0=F1;
        Pold=Pnew;


        ii=2:M-1;   jj=2:N-1; %Nodi interni
        %Calcolo portata uscita radiale
        GN(ii,jj)=-(Pold(ii-1,jj).*H0(ii-1,jj).^3.*Rv(ii-1,jj)+Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii,jj)-Pold(ii-1,jj));
        GS(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj)+Pold(ii+1,jj).*H0(ii+1,jj).^3.*Rv(ii+1,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii+1,jj)-Pold(ii,jj));
        %Calcolo portata uscita circonferenziale
        gOp(ii,jj)=-(Pold(ii,jj-1).*H0(ii,jj-1).^3+Pold(ii,jj).*H0(ii,jj).^3)./(12*mu*Rg*Temp*(Rv(ii,jj-1)+Rv(ii,jj)).*deltat).*(Pold(ii,jj)-Pold(ii,jj-1));
        gOc(ii,jj)=omega*(Pold(ii,jj-1).*H0(ii,jj-1).*Rv(ii,jj-1)+Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj))./(4*Rg*Temp);
        gO(ii,jj)=gOp(ii,jj)+gOc(ii,jj);
        gEp(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3+Pold(ii,jj+1).*H0(ii,jj+1).^3)./(12*mu*Rg*Temp*(Rv(ii,jj)+Rv(ii,jj+1)).*deltat).*(Pold(ii,jj+1)-Pold(ii,jj));
        gEc(ii,jj)=omega*(Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj)+Pold(ii,jj+1).*H0(ii,jj+1).*Rv(ii,jj+1))./(4*Rg*Temp);
        gE(ii,jj)=gEp(ii,jj)+gEc(ii,jj);
        %Calcolo pressione meato da equazione di continuit
        Pnew(ii,jj)=Pold(ii,jj)+((GN(ii,jj)-GS(ii,jj))*deltat+(gO(ii,jj)-gE(ii,jj))*deltar).*(dt*Rg*Temp)./(H0(ii,jj).*Rv(ii,jj)*deltar*deltat);

        %Calcolo errore Pressione
        err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
        % Err_P_i(iter)=err_P;

        %Diverge?
        if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
            fprintf('Iterations diverge\n');
            return;
        end
        %Calcolo della capacit di carico
        F1=sum((Pnew-pa)*deltar*deltat.*Rv,'all');

        %Calcolo della portata in uscita O-N-E-S
        Gin=sum(GN(ii,jj)*deltat+gO(ii,jj)*deltar,'all');
        Gout=sum(GS(ii,jj)*deltat+gE(ii,jj)*deltar,'all');
        % %Calcolo errore
        err_F=(F1-F0)/F1;
        err_G_num=sum(Gin-Gout,'all');
        err_G=err_G_num/Gout;

        % if contatore==no_punti
        %     Ft=[Ft F1*no_pad];
        %     Gint=[Gint Gin];
        %     Goutt=[Goutt Gout];
        %     Err_P=[Err_P err_P];
        %     Err_G=[Err_G err_G];
        %
        %     Err_F=[Err_F err_F];
        %     contatore=0;
        % end

    end
    toc
    W(h_i)=F1*no_grooves;
    Qin(h_i)=Gin*cG;
    Qout(h_i)=Gout*cG;

    figure
    surf(X*1e3,Y*1e3,Pnew), hold on
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    grid on
    % set(gca,'FontSize', 24)
    pause(0.5)
end

%% Curve Caratteristiche
% Capacit di carico
figure
plot(h_vec*1e6,W,'b'),hold on
plot(h_vec*1e6,W,'ro'),hold on
xlabel('Air gap $h$ [$\mu m$]'),ylabel('Load Capacity $W$ (N)')
title('Spiral Bearing load capacity at minium rotational speed $\omega_{min}$')
% legend('Numerical','Experimental')
grid on

% Portata Ingresso-Uscita
figure
plot(h_vec*1e6,Qin,'b'),hold on
plot(h_vec*1e6,Qout,'ro'),hold on
xlabel('Angular Speed $\omega$ (krpm)'),ylabel('Air Flow $Q$ (l/min)'),


%% Salvataggio
W_spiral = W;
h_vec_spiral = h_vec;
save Spiral_static W_spiral h_vec_spiral

fid = fopen('sim_data_spiral.txt','wt');
fprintf(fid,'dt: %+.2e\n',dt);
fprintf(fid,'M: %d\nN: %d\n',M,N);
fclose(fid);


   